#pragma once

#include <random>

namespace yrpopper {

struct random_uint_generator
{
    size_t operator()(size_t min, size_t max) const
    {
        if (min > max)
        {
            throw std::invalid_argument("`min <= max` is required for random generator range");
        }

        static thread_local std::mt19937 generator(time(0));
        std::uniform_int_distribution<size_t> distribution_(min, max);
        return distribution_(generator);
    }
};

} // namespace yrpopper
