#include "task.h"

namespace yrpopper {

const std::string& error_message(code c)
{
    static constexpr std::initializer_list<const char*> names = { "ok",
                                                                  "bad task",
                                                                  "resolve error",
                                                                  "connection error",
                                                                  "ssl error",
                                                                  "transport error",
                                                                  "timeout error",
                                                                  "login error",
                                                                  "cant get message list",
                                                                  "cacher service unavailable",
                                                                  "smtp save error",
                                                                  "blackbox service unavailable",
                                                                  "no session error",
                                                                  "database error",
                                                                  "internal error",
                                                                  "nonexistent user",
                                                                  "bad karma",
                                                                  "unknown status" };

    static_assert(
        names.size() == static_cast<size_t>(code::COUNT),
        "Error codes count doesn't correspond to error names count");

    static const std::vector<std::string> error_names(names.begin(), names.end());
    return error_names[static_cast<int>(c)];
}

bool is_public_error(error ec)
{
    return ec == code::connect_error || ec == code::resolve_error || ec == code::login_error ||
        ec == code::bad_karma || ec == code::nonexistent_user || ec == code::ssl_error;
}

struct error_category : public boost::system::error_category
{
    const char* name() const noexcept override
    {
        return "yrpopper::error_category";
    }

    std::string message(int v) const override
    {
        return error_message(static_cast<code>(v));
    }
};

const boost::system::error_category& get_error_category()
{
    static struct error_category instance;
    return instance;
}

}
