#pragma once

#include <yplatform/error.h>

#include <string>

namespace yrpopper {

using error = yplatform::error;

enum class code
{
    ok = 0,
    bad_task,
    resolve_error,
    connect_error,
    ssl_error,
    transport_error,
    timeout_error,
    login_error,
    message_list_error,
    cacher_service_error,
    smtp_save_error,
    blackbox_error,
    no_session_error,
    db_error,
    internal_error,
    nonexistent_user,
    bad_karma,
    unknown,

    COUNT
};

const std::string& to_string(code status);

bool is_public_error(error ec);

const boost::system::error_category& get_error_category();

}

namespace yplatform {

template <>
struct is_error_enum<yrpopper::code>
{
    static const bool value = true;
};

}

namespace yrpopper {

inline const boost::system::error_category& error_category(code /*e*/)
{
    return get_error_category();
}

}
