#pragma once

#include <common/context.h>

#include <yplatform/log.h>
#include <yplatform/module.h>
#include <yplatform/find.h>

namespace yrpopper { namespace typed_log {

namespace tl = yplatform::log::typed;

inline tl::attributes_map make_common_attrs(
    PlatformContextPtr ctx,
    const std::string& type,
    popid_t popid,
    const std::string& dst_uid,
    const std::string src_email,
    const std::string& status,
    const std::string& reason)
{
    tl::attributes_map am;
    am << tl::make_attr("type", type) << tl::make_attr("y_context", ctx->uniq_id())
       << tl::make_attr("collector", popid) << tl::make_attr("dst_uid", dst_uid)
       << tl::make_attr("src_email", src_email) << tl::make_attr("status", status)
       << tl::make_attr("reason", reason);
    return am;
}

inline void log_store_message(
    rpop_context_ptr ctx,
    const std::string& status,
    const std::string& reason,
    const std::string& dst_folder,
    const std::string& src_folder,
    const std::string& src_message_id,
    const std::string& src_type,
    const std::string& hdrMessageId,
    const std::string& smtp_response = "")
{
    yplatform::log::tskv_logger log(YGLOBAL_LOG_SERVICE, "typed_log");
    auto task = ctx->task;
    auto common_attrs = make_common_attrs(
        ctx, "store_message", task->popid, task->bb_info.getUid(), task->email, status, reason);
    YLOG(log, info) << common_attrs << tl::make_attr("dst_email", task->bb_info.getEmail())
                    << tl::make_attr("dst_folder", dst_folder)
                    << tl::make_attr("src_server", task->server)
                    << tl::make_attr("src_folder", src_folder)
                    << tl::make_attr("src_message_id", src_message_id)
                    << tl::make_attr("src_type", src_type)
                    << tl::make_attr("hdr_message_id", hdrMessageId)
                    << tl::make_attr("smtp_response", smtp_response);
}

inline void log_api(
    PlatformContextPtr ctx,
    const std::string& uid,
    const std::string& suid,
    const popid_t& popid,
    const std::string& src_email,
    const std::string& method,
    const std::string& status,
    const std::string& reason = "")
{
    yplatform::log::tskv_logger log(YGLOBAL_LOG_SERVICE, "typed_log");
    auto common_attrs = make_common_attrs(ctx, "api", popid, uid, src_email, status, reason);
    YLOG(log, info) << common_attrs << tl::make_attr("suid", suid)
                    << tl::make_attr("method", method);
}

inline void log_iteration(rpop_context_ptr ctx, error ec, time_t duration, std::size_t bad_retries)
{
    yplatform::log::tskv_logger log(YGLOBAL_LOG_SERVICE, "typed_log");
    auto status = ec ? "error" : "success";
    auto task = ctx->task;
    auto common_attrs = make_common_attrs(
        ctx, "iteration", task->popid, task->bb_info.getUid(), task->email, status, ec.message());
    YLOG(log, info) << common_attrs << tl::make_attr("sent_size", ctx->sent_size)
                    << tl::make_attr("duration", duration)
                    << tl::make_attr("sent_count", ctx->sent_count)
                    << tl::make_attr("src_server", task->server)
                    << tl::make_attr("src_type", task->use_imap ? "imap" : "pop3")
                    << tl::make_attr("validated", task->validated)
                    << tl::make_attr("suid", task->suid)
                    << tl::make_attr("leave_msgs", task->leave_msgs)
                    << tl::make_attr("mark_archive_read", task->mark_archive_read)
                    << tl::make_attr("server_port", task->port)
                    << tl::make_attr("use_ssl", task->use_ssl)
                    << tl::make_attr("bad_retries", bad_retries);
}

}}
