#pragma once

#include <common/config.h>
#include <boost/shared_ptr.hpp>

#include <ymod_imapclient/imap_result.h>
#include <unordered_map>
#include <map>
#include <list>
#include <set>

using ymod_imap_client::ImapMessageVector;

namespace yrpopper {

// true if common message, and false if message is invalid:
// don`t delete it from server and cacher
typedef std::unordered_map<string, bool> uidl_map;
typedef std::list<std::pair<string, bool>> new_uidl_map;
typedef boost::shared_ptr<uidl_map> uidl_map_ptr;

struct imap_folder
{
    uint64_t folder_id = 0;
    string name;

    uint32_t uidvalidity = 0;
    uint32_t nextuid = 0;
    uint32_t exists = 0;

    bool inited = false;
};
typedef boost::shared_ptr<imap_folder> imap_folder_ptr;
typedef std::map<string, imap_folder_ptr> imap_folders;
typedef boost::shared_ptr<imap_folders> imap_folders_ptr;

typedef std::set<unsigned int> imap_uidl_map;
typedef boost::shared_ptr<imap_uidl_map> imap_uidl_map_ptr;

struct http_folder
{
    uint64_t folder_id = 0;
    string external_folder_id;
    string name;
    std::time_t last_synced_message_ts = 0;
    std::time_t last_synced_message_received_ts = 0;

    uint64_t message_count = 0;
    uint64_t collected_count = 0;
    uint64_t error_count = 0;
    uint64_t bad_message_retries = 0;
};
typedef boost::shared_ptr<http_folder> http_folder_ptr;
typedef std::map<string, http_folder_ptr> http_folders;
typedef boost::shared_ptr<http_folders> http_folders_ptr;

} // namespace yrpopper
