#pragma once

#include <db/api_interface.h>
#include <db/query_dispatcher/query_dispatcher.h>

#include <common/context.h>
#include <common/data_source.h>

#include <memory>

namespace yrpopper { namespace db {

class ApiInterface
{
public:
    ApiInterface();

    future_task_info_list list(PlatformContextPtr ctx, const std::string& suid);

    future_task_info_list info(PlatformContextPtr ctx, const std::string& suid, popid_t popid);
    future_task_info_list info(PlatformContextPtr ctx, popid_t popid);
    future_popid_t create(PlatformContextPtr ctx, const std::string& suid, const task_info& task);
    future_void_t remove(PlatformContextPtr ctx, const std::string& suid, popid_t popid);
    future_void_t edit(PlatformContextPtr ctx, const std::string& suid, const task_info& task);
    future_void_t resetStatus(
        PlatformContextPtr ctx,
        const std::string& suid,
        const task_info& task);

    future_void_t enableCollector(
        PlatformContextPtr ctx,
        const std::string& suid,
        popid_t popid,
        bool on);
    future_void_t enableAbook(
        PlatformContextPtr ctx,
        const std::string& suid,
        const popid_t& popid);

    future_string getCollectorOwner(PlatformContextPtr ctx, popid_t popid);

    FutureStatusData status(PlatformContextPtr ctx, popid_t popid);
    FutureStatusData httpStatus(PlatformContextPtr ctx, popid_t popid);
    future_imap_folders loadImapFolders(PlatformContextPtr ctx, popid_t popid);

private:
    query_dispatcher_ptr dispatcher;
};

using ApiInterfacePtr = std::shared_ptr<ApiInterface>;

} // namespace db
} // namespace yrpopper
