#pragma once

#include <common/config.h>
#include <common/context.h>
#include <ymod_pq/response_handler.h>

namespace yrpopper { namespace db { namespace handlers {

class chunk_index : public ymod_pq::response_handler
{
public:
    chunk_index() : chunk_requesters_(boost::make_shared<chunk_requester_dict_t>())
    {
    }

    void handle_cell(unsigned /* row */, unsigned col, const std::string& value, bool /* is_null */)
    {
        if (col == 0)
        {
            last_id_ = boost::lexical_cast<uint64_t>(value);
        }
        else
        {
            chunk_requesters_->insert(std::make_pair(last_id_, value));
            last_id_ = 0;
        }
    }

    unsigned column_count() const
    {
        return 2;
    }

    chunk_requester_dict_ptr result()
    {
        return chunk_requesters_;
    }

private:
    uint64_t last_id_;
    chunk_requester_dict_ptr chunk_requesters_;
};

typedef boost::shared_ptr<chunk_index> chunk_index_ptr;

}}}
