#pragma once

#include <common/context.h>
#include <ymod_pq/response_handler.h>

namespace yrpopper { namespace db { namespace handlers {

class chunk_request : public ymod_pq::response_handler
{
public:
    chunk_request() : has_value_(false), chunk_id_(0)
    {
    }

    void handle_cell(
        unsigned /* row */,
        unsigned /* col */,
        const std::string& value,
        bool /* is_null */)
    {
        try
        {
            chunk_id_ = boost::lexical_cast<uint64_t>(value);
        }
        catch (...)
        {
        }
    }

    unsigned column_count() const
    {
        return 1;
    }

    bool has_value() const
    {
        return has_value_;
    }

    uint64_t result() const
    {
        return chunk_id_;
    }

private:
    bool has_value_;
    uint64_t chunk_id_;
};

typedef boost::shared_ptr<chunk_request> chunk_request_ptr;
}}}
