#pragma once

#include <common/context.h>
#include <ymod_pq/response_handler.h>
#include <boost/lexical_cast.hpp>

namespace yrpopper { namespace db { namespace handlers {

class http_folders : public ymod_pq::response_handler
{
    yrpopper::http_folder_ptr current_;
    yrpopper::http_folders_ptr folders_;

public:
    enum
    {
        folder_id,
        name,
        last_synced_message_ts,
        message_count,
        collected_count,
        error_count,
        bad_message_retries,
        last_synced_message_received_ts,

        column_cnt
    };

    http_folders() : current_(new http_folder), folders_(new yrpopper::http_folders)
    {
    }

    void handle_cell(unsigned /* row */, unsigned col, const string& value, bool is_null)
    {
        switch (col)
        {
        case folder_id:
            current_->folder_id = boost::lexical_cast<uint64_t>(value);
            break;
        case name:
            current_->name = value;
            break;
        case last_synced_message_ts:
            current_->last_synced_message_ts = boost::lexical_cast<std::time_t>(value);
            break;
        case message_count:
            current_->message_count = boost::lexical_cast<uint64_t>(value);
            break;
        case collected_count:
            current_->collected_count = boost::lexical_cast<uint64_t>(value);
            break;
        case error_count:
            current_->error_count = boost::lexical_cast<uint64_t>(value);
            break;
        case bad_message_retries:
            current_->bad_message_retries = boost::lexical_cast<uint64_t>(value);
            break;
        case last_synced_message_received_ts:
            current_->last_synced_message_received_ts =
                is_null ? 0 : boost::lexical_cast<std::time_t>(value);
            break;
        }
    }

    void handle_row_end(unsigned /* row */)
    {
        (*folders_)[current_->name] = current_;
        current_.reset(new http_folder);
    }

    unsigned column_count() const
    {
        return column_cnt;
    }

    yrpopper::http_folders_ptr result()
    {
        return folders_;
    }
};

typedef boost::shared_ptr<http_folders> http_folders_ptr;

}}}
