#pragma once

#include <common/config.h>
#include <ymod_pq/response_handler.h>

namespace yrpopper { namespace db { namespace handlers {

class HttpStatusHandler : public ymod_pq::response_handler
{
    enum StatusCols
    {
        ColFolderId = 0,
        ColFolderName = 1,
        ColMsgCount = 2,
        ColMsgCollected = 3,
        ColMsgErrors = 4,

        ColCount = 5
    };

public:
    void handle_cell(unsigned /* row */, unsigned col, const std::string& value, bool is_null)
    {
        switch (col)
        {
        case HttpStatusHandler::ColFolderId:
            current.folderId = is_null ? 0 : boost::lexical_cast<uint64_t>(value);
            break;
        case HttpStatusHandler::ColFolderName:
            current.folderName = value;
            break;
        case HttpStatusHandler::ColMsgCount:
            current.messages = is_null ? 0 : boost::lexical_cast<size_t>(value);
            break;
        case HttpStatusHandler::ColMsgCollected:
            current.collected = is_null ? 0 : boost::lexical_cast<size_t>(value);
            break;
        case HttpStatusHandler::ColMsgErrors:
            current.errors = is_null ? 0 : boost::lexical_cast<size_t>(value);
            break;
        }
    }

    void handle_row_end(unsigned /*row*/)
    {
        status.push_back(current);
        current = FolderStatus();
    }

    unsigned column_count() const
    {
        return HttpStatusHandler::ColCount;
    }

    const StatusData& result() const
    {
        return status;
    }

private:
    FolderStatus current;
    StatusData status;
};

typedef boost::shared_ptr<HttpStatusHandler> HttpStatusHandlerPtr;

} // namespace handlers
} // namespace pq
} // namespace yrpopper
