#pragma once

#include <common/context.h>
#include <ymod_pq/response_handler.h>
#include <boost/lexical_cast.hpp>

namespace yrpopper { namespace db { namespace handlers {

class imap_folders : public ymod_pq::response_handler
{
    yrpopper::imap_folder_ptr current_;
    yrpopper::imap_folders_ptr folders_;

public:
    enum
    {
        folder_id,
        name,
        uidvalidity,
        nextuid,
        exists,
        inited,

        column_cnt
    };

    imap_folders() : current_(new imap_folder), folders_(new yrpopper::imap_folders)
    {
    }

    void handle_cell(unsigned /* row */, unsigned col, const string& value, bool is_null)
    {
        switch (col)
        {
        case folder_id:
            current_->folder_id = boost::lexical_cast<uint64_t>(value);
            break;
        case name:
            current_->name = value;
            break;
        case uidvalidity:
            current_->uidvalidity = boost::lexical_cast<int>(value);
            ;
            break;
        case nextuid:
            current_->nextuid = boost::lexical_cast<int>(value);
            break;
        case exists:
            current_->exists = boost::lexical_cast<int>(value);
            break;
        case inited:
            if (is_null) break;
            if (value != "f")
            {
                current_->inited = true;
            }
            break;
        }
    }

    void handle_row_end(unsigned /* row */)
    {
        (*folders_)[current_->name] = current_;
        current_.reset(new imap_folder);
    }

    unsigned column_count() const
    {
        return column_cnt;
    }

    yrpopper::imap_folders_ptr result()
    {
        return folders_;
    }
};

typedef boost::shared_ptr<imap_folders> imap_folders_ptr;

}}}
