#pragma once

#include <common/context.h>
#include <ymod_pq/response_handler.h>
#include <boost/lexical_cast.hpp>

namespace yrpopper { namespace db { namespace handlers {

class imap_uidl_list : public ymod_pq::response_handler
{
public:
    imap_uidl_list() : uidls_(new imap_uidl_map)
    {
    }

    void handle_cell(
        unsigned /* row */,
        unsigned /* col */,
        const string& value,
        bool /* is_null */)
    {
        uidls_->insert(boost::lexical_cast<unsigned int>(value));
    }

    unsigned column_count() const
    {
        return 1;
    }

    imap_uidl_map_ptr result()
    {
        return uidls_;
    }

private:
    imap_uidl_map_ptr uidls_;
};

typedef boost::shared_ptr<imap_uidl_list> imap_uidl_list_ptr;

}}}
