#pragma once

#include <common/config.h>
#include <ymod_pq/response_handler.h>

namespace yrpopper { namespace db { namespace handlers {

class new_folderid : public ymod_pq::response_handler
{
public:
    new_folderid() : id_(0)
    {
    }

    void handle_cell(
        unsigned /* row */,
        unsigned /* col */,
        const string& value,
        bool /* is_null */)
    {
        id_ = boost::lexical_cast<uint64_t>(value);
    }

    unsigned column_count() const
    {
        return 1;
    }

    const uint64_t& result() const
    {
        return id_;
    }

private:
    uint64_t id_;
};

typedef boost::shared_ptr<new_folderid> new_folderid_ptr;

}}}
