#pragma once

#include <common/config.h>
#include <ymod_pq/response_handler.h>

namespace yrpopper { namespace db { namespace handlers {

class api_new_popid : public ymod_pq::response_handler
{
public:
    void handle_cell(
        unsigned /* row */,
        unsigned /* col */,
        const string& value,
        bool /* is_null */)
    {
        id_ = boost::lexical_cast<popid_t>(value);
    }

    unsigned column_count() const
    {
        return 1;
    }

    const popid_t& result() const
    {
        return id_;
    }

private:
    popid_t id_;
};

typedef boost::shared_ptr<api_new_popid> api_new_popid_ptr;

}}}
