#include <common/util.h>
#include <db/handlers/rpop_list.h>
#include <exception>
#include <yplatform/util.h>
#include <boost/lexical_cast.hpp>

namespace yrpopper::db::handlers {

static const boost::posix_time::ptime DATE_UNREAD_ARCHIVE =
    boost::posix_time::time_from_string("2000-01-01 8:00:00");

void rpop_list::handle_cell(unsigned /* row */, unsigned col, const string& value, bool is_null)
{
    switch (col)
    {
    case column_popid:
        current_task_->popid = boost::lexical_cast<popid_t>(value);
        break;
    case column_uname:
        current_task_->suid = value;
        break;
    case column_server:
        current_task_->server = value;
        break;
    case column_port:
        current_task_->port = boost::lexical_cast<unsigned>(value);
        break;
    case column_login:
        current_task_->login = value;
        break;
    case column_password:
        current_task_->password = value;
        break;
    case column_last_connect:
        if (!is_null) current_task_->last_connect = boost::lexical_cast<time_t>(value);
        break;
    case column_session_duration:
        current_task_->session_duration = is_null ? 0 : boost::lexical_cast<std::time_t>(value);
        break;
    case column_bad_retries:
        current_task_->bad_retries = is_null ? 0 : boost::lexical_cast<unsigned>(value);
        break;
    case column_leave_msg:
        current_task_->leave_msgs = yplatform::util::iequals(value, string("1"));
        break;
    case column_use_ssl:
        current_task_->use_ssl = yplatform::util::iequals(value, string("Y"));
        break;
    case column_use_email:
        current_task_->email = value;
        break;
    case column_date_unread:
        current_task_->mark_archive_read =
            (boost::posix_time::time_from_string(value) > DATE_UNREAD_ARCHIVE);
        break;
    case abook_sync_state:
        current_task_->abook_sync_state = is_null ? 0 : boost::lexical_cast<unsigned>(value);
        break;
    case abook_sync_start_date:
        current_task_->abook_sync_date = to_unix_time(boost::posix_time::time_from_string(value));
        break;
    case column_create_date:
        current_task_->create_date = to_unix_time(boost::posix_time::time_from_string(value));
        break;
    case column_validated:
        current_task_->validated = boost::lexical_cast<unsigned>(value);
        break;
    case column_uidl_hash:
        current_task_->uidl_hash = value;
        break;
    case column_chunk_id:
        current_task_->chunk_id = is_null ? 0 : boost::lexical_cast<uint64_t>(value);
        break;
    case column_use_imap:
        current_task_->use_imap = boost::lexical_cast<unsigned>(value);
        break;
    case column_root_folder:
        current_task_->root_folder = value;
        break;
    case column_is_oauth:
        if (is_null) break;
        if (value != "f")
        {
            is_oauth = true;
        }
        break;
    case column_label:
        current_task_->label_id = value;
        break;
    default:
        throw std::runtime_error("unknown column index");
    }
}

void rpop_list::handle_row_end(unsigned /* row */)
{
    if (is_oauth)
    {
        std::swap(current_task_->password, current_task_->oauth_refresh_token);
    }
    task_list_->push_back(current_task_);
    current_task_.reset(new task);
    is_oauth = false;
}

} // namespace yrpopper::db::handlers
