#pragma once

#include <common/util.h>
#include <common/task.h>
#include <common/context.h>
#include <ymod_pq/response_handler.h>

namespace yrpopper { namespace db { namespace handlers {

class rpop_list : public ymod_pq::response_handler
{
public:
    explicit rpop_list() : task_list_(new task_ptr_list), current_task_(new task), is_oauth(false)
    {
    }

    void handle_cell(unsigned row, unsigned col, const string& value, bool is_null);

    unsigned column_count() const
    {
        return all_column_count;
    }

    void handle_row_end(unsigned row);

    task_ptr_list_ptr result()
    {
        return task_list_;
    }

private:
    enum COLUMN_INDEX
    {
        column_popid = 0,
        column_uname,
        column_server,
        column_port,
        column_login,
        column_password,
        column_last_connect,
        column_session_duration,
        column_bad_retries,
        column_leave_msg,
        column_use_ssl,
        column_use_email,
        column_date_unread,
        abook_sync_state,
        abook_sync_start_date,
        column_create_date,
        column_validated,
        column_uidl_hash,
        column_chunk_id,
        column_use_imap,
        column_root_folder,
        column_is_oauth,
        column_label,
        all_column_count
    };
    task_ptr_list_ptr task_list_;
    task_ptr current_task_;
    bool is_oauth;
};

typedef boost::shared_ptr<rpop_list> rpop_list_ptr;

}}}
