#pragma once

#include <common/config.h>
#include <ymod_pq/response_handler.h>

namespace yrpopper { namespace db { namespace handlers {

class RpopOwnerHandler : public ymod_pq::response_handler
{
public:
    void handle_cell(
        unsigned /* row */,
        unsigned /* col */,
        const std::string& value,
        bool /* is_null */)
    {
        owner = value;
    }

    unsigned column_count() const
    {
        return 1;
    }

    const std::string& result() const
    {
        return owner;
    }

private:
    std::string owner;
};

typedef boost::shared_ptr<RpopOwnerHandler> RpopOwnerHandlerPtr;

} // namespace handlers
} // namespace pq
} // namespace yrpopper
