#pragma once

#include <common/config.h>
#include <ymod_pq/response_handler.h>

namespace yrpopper { namespace db { namespace handlers {

class StatusHandler : public ymod_pq::response_handler
{
    enum StatusCols
    {
        ColFolderId = 0,
        ColMsgCount = 1,
        ColMsgCollected = 2,
        ColMsgErrors = 3
    };

public:
    void handle_cell(unsigned /* row */, unsigned col, const std::string& value, bool is_null)
    {
        switch (col)
        {
        case StatusHandler::ColFolderId:
            current.folderId = is_null ? 0 : boost::lexical_cast<uint64_t>(value);
            break;
        case StatusHandler::ColMsgCount:
            current.messages = is_null ? 0 : boost::lexical_cast<size_t>(value);
            break;
        case StatusHandler::ColMsgCollected:
            current.collected = is_null ? 0 : boost::lexical_cast<size_t>(value);
            break;
        case StatusHandler::ColMsgErrors:
            current.errors = is_null ? 0 : boost::lexical_cast<size_t>(value);
            break;
        }
    }

    void handle_row_end(unsigned /*row*/)
    {
        status.push_back(current);
        current = FolderStatus();
    }

    unsigned column_count() const
    {
        return 1;
    }

    const StatusData& result() const
    {
        return status;
    }

private:
    FolderStatus current;
    StatusData status;
};

typedef boost::shared_ptr<StatusHandler> StatusHandlerPtr;

} // namespace handlers
} // namespace pq
} // namespace yrpopper
