#include <db/handlers/task_info_handler.h>

#include <common/util.h>

#include <yplatform/util.h>
#include <boost/lexical_cast.hpp>
#include <exception>

namespace yrpopper::db::handlers {

void task_info_handler::handle_cell(
    unsigned /* row */,
    unsigned col,
    const string& value,
    bool is_null)
{

    if (new_row_ && col == column_popid) // first column must be popid
    {
        popid_t popid = boost::lexical_cast<popid_t>(value);

        if (result_->empty() || (current().popid != popid)) // new rpop ?
        {
            result_->push_back(task_info()); // new
            new_row_ = false;
            is_oauth = false;
        }
    }

    switch (col)
    {
    case column_popid:
        current().popid = boost::lexical_cast<popid_t>(value);
        break;
    case column_server:
        current().server = value;
        break;
    case column_port:
        current().port = boost::lexical_cast<unsigned>(value);
        break;
    case column_login:
        current().login = value;
        break;
    case column_password:
        current().password = value;
        break;
    case column_use_ssl:
        current().use_ssl = yplatform::util::iequals(value, string("Y"));
        break;
    case column_email:
        current().email = value;
        break;
    case column_is_on:
        current().is_on = boost::lexical_cast<uint16_t>(value);
        break;
    case column_last_connect:
        if (!is_null) current().last_connect = boost::lexical_cast<std::time_t>(value);
        break;
    case column_session_duration:
        if (!is_null) current().session_duration = boost::lexical_cast<std::time_t>(value);
        break;
    case column_bad_retries:
        current().bad_retries = boost::lexical_cast<unsigned>(value);
        break;
    case column_error_status:
        current().error_status = value;
        break;
    case column_last_msg_count:
        if (!is_null) current().last_msg_count = boost::lexical_cast<std::size_t>(value);
        break;
    case column_leave_msg:
        current().leave_msgs = yplatform::util::iequals(value, string("1"));
        break;
    case column_abook_sync_state:
        if (!is_null) current().abook_sync_state = boost::lexical_cast<unsigned>(value);
        break;
    case column_date_unread:
        current().mark_archive_read = !yplatform::util::iequals(value, string("0"));
        break;
    case column_actionid:
        if (!is_null)
        {
            actionid_t actionid = boost::lexical_cast<actionid_t>(value);
            current().action.push_back(actionid);
        }
        break;
    case column_use_imap:
        current().use_imap = boost::lexical_cast<unsigned>(value);
        break;
    case column_root_folder:
        current().root_folder = value;
        break;
    case column_is_oauth:
        if (is_null) break;
        if (value != "f")
        {
            is_oauth = true;
        }
        break;
    case column_validated:
        current().validated = boost::lexical_cast<unsigned>(value);
        break;
    case column_uidl_hash:
        current().uidl_hash = value;
        break;
    case column_label:
        current().label_id = value;
        break;
    default:
        throw std::runtime_error("unknown column index");
    }
}

} // namespace yrpopper::db::handlers
