#pragma once

#include <common/task.h>
#include <common/util.h>
#include <common/data_source.h>
#include <ymod_pq/response_handler.h>

namespace yrpopper { namespace db { namespace handlers {

class task_info_handler : public ymod_pq::response_handler
{
public:
    task_info_handler() : new_row_(true), result_(new task_info_list), is_oauth(false)
    {
    }
    void handle_cell(unsigned row, unsigned col, const string& value, bool is_null);

    unsigned column_count() const
    {
        return all_column_count;
    }

    void handle_row_end(unsigned /* row */)
    {
        if (is_oauth)
        {
            std::swap(current().password, current().oauth_refresh_token);
        }
        new_row_ = true;
    }

    const task_info_list_ptr& result() const
    {
        return result_;
    }

private:
    enum COLUMN_INDEX
    {
        column_popid = 0,
        column_server,
        column_port,
        column_login,
        column_password,
        column_use_ssl,
        column_email,
        column_is_on,
        column_last_connect,
        column_session_duration,
        column_bad_retries,
        column_error_status,
        column_last_msg_count,
        column_leave_msg,
        column_abook_sync_state,
        column_date_unread,
        column_actionid,
        column_use_imap,
        column_root_folder,
        column_is_oauth,
        column_validated,
        column_uidl_hash,
        column_label,
        all_column_count
    };

    task_info& current()
    {
        return result_->back();
    }

    bool new_row_;
    task_info_list_ptr result_;
    bool is_oauth;
};

typedef boost::shared_ptr<task_info_handler> task_info_handler_ptr;

}}}
