#pragma once

#include <common/context.h>
#include <ymod_pq/response_handler.h>
#include <boost/lexical_cast.hpp>

namespace yrpopper { namespace db { namespace handlers {

class uidl_list : public ymod_pq::response_handler
{
public:
    void handle_cell(
        unsigned /* row */,
        unsigned /* col */,
        const string& value,
        bool /* is_null */)
    {
        string::size_type uidl_end = value.find_first_of(" \t\r\n", 0);
        string::size_type flag_beg = value.find_first_not_of(" \t\r\n", uidl_end);
        string::size_type flag_end = value.find_first_of(" \t\r\n", flag_beg);
        if (uidl_end != value.npos)
        {
            uidls_->insert(std::make_pair(value.substr(0, uidl_end), flag_beg == flag_end));
        }
        else
        {
            uidls_->insert(std::make_pair(value, flag_beg == flag_end));
        }
    }

    unsigned column_count() const
    {
        return 1;
    }

    uidl_map_ptr result() const
    {
        return uidls_;
    }

private:
    uidl_map_ptr uidls_ = boost::make_shared<uidl_map>();
};

typedef boost::shared_ptr<uidl_list> uidl_list_ptr;

}}}
