#include <db/http_collector_interface.h>
#include <db/query/request_query.h>
#include <db/query/execute_query.h>

#include <db/handlers/http_folders.h>
#include <db/handlers/new_folderid.h>

#include <yplatform/find.h>

namespace yrpopper::db {

HttpCollectorInterface::HttpCollectorInterface()
{
    dispatcher = yplatform::find<query_dispatcher>("query_dispatcher");
}

future_http_folders HttpCollectorInterface::loadHttpFolders(PlatformContextPtr ctx, popid_t popid)
{
    using HttpFoldersRequestQuery = query::RequestQuery<http_folders_ptr, handlers::http_folders>;
    auto req = std::make_shared<HttpFoldersRequestQuery>(ctx, "http_folders_list");

    req->addArgs(popid);
    return dispatcher->run(req, popid, request_target::try_replica);
}

future_uint64_t HttpCollectorInterface::updateOrCreateHttpFolder(
    PlatformContextPtr ctx,
    popid_t popid,
    http_folder_ptr folder)
{
    using UpdateFolderRequestQuery = query::RequestQuery<uint64_t, handlers::new_folderid>;
    auto req = std::make_shared<UpdateFolderRequestQuery>(ctx, "update_or_create_http_folder");

    req->addArgs(
        popid,
        folder->name,
        folder->last_synced_message_ts,
        folder->message_count,
        folder->collected_count,
        folder->error_count,
        folder->bad_message_retries,
        folder->last_synced_message_received_ts);
    return dispatcher->run(req, popid, request_target::master);
}

} // namespace yrpopper::db
