#pragma once

#include <db/query_dispatcher/query_dispatcher.h>

#include <common/context.h>
#include <common/data_source.h>

#include <memory>

namespace yrpopper { namespace db {

class HttpCollectorInterface
{
public:
    HttpCollectorInterface();

    future_http_folders loadHttpFolders(PlatformContextPtr ctx, popid_t popid);
    future_uint64_t updateOrCreateHttpFolder(PlatformContextPtr ctx, popid_t popid, http_folder_ptr folder);

private:
    query_dispatcher_ptr dispatcher;
};

using HttpCollectorInterfacePtr = std::shared_ptr<HttpCollectorInterface>;

} // namespace db
} // namespace yrpopper
