#pragma once

#include <db/imap_collector_interface.h>
#include <db/query_dispatcher/query_dispatcher.h>

#include <common/context.h>
#include <common/data_source.h>

#include <memory>

namespace yrpopper { namespace db {

class ImapCollectorInterface
{
public:
    ImapCollectorInterface();

    future_imap_folders loadImapFolders(PlatformContextPtr ctx, popid_t popid);
    future_uint64_t appendImapFolder(PlatformContextPtr ctx, popid_t popid, imap_folder_ptr folder);
    future_void_t deleteImapFolders(
        PlatformContextPtr ctx,
        popid_t popid,
        imap_folders_ptr folders);
    future_void_t editImapFolder(PlatformContextPtr ctx, imap_folder_ptr folder);

    future_imap_uidl_map loadImapMessages(
        PlatformContextPtr ctx,
        uint64_t folderId,
        const std::string& state,
        uint32_t count);
    future_void_t addInitialImapMessages(
        PlatformContextPtr ctx,
        uint64_t folderId,
        std::vector<int64_t>&& uidls);
    future_void_t editImapMessage(
        PlatformContextPtr ctx,
        uint64_t folderId,
        uint32_t uidl,
        const std::string& newState);

private:
    query_dispatcher_ptr dispatcher;
};

using ImapCollectorInterfacePtr = std::shared_ptr<ImapCollectorInterface>;

} // namespace db
} // namespace yrpopper
