#pragma once

#include <db/legacy_interface.h>
#include <db/api_interface.h>
#include <db/http_collector_interface.h>
#include <db/imap_collector_interface.h>
#include <db/pop3_collector_interface.h>
#include <db/scheduler_interface.h>

namespace yrpopper { namespace db {

class InterfaceProvider
{
public:
    static ApiInterfacePtr getApiInterface()
    {
        return std::make_shared<ApiInterface>();
    }
    static HttpCollectorInterfacePtr getHttpCollectorInterface()
    {
        return std::make_shared<HttpCollectorInterface>();
    }
    static ImapCollectorInterfacePtr getImapCollectorInterface()
    {
        return std::make_shared<ImapCollectorInterface>();
    }
    static Pop3CollectorInterfacePtr getPop3CollectorInterface()
    {
        return std::make_shared<Pop3CollectorInterface>();
    }
    static SchedulerInterfacePtr getSchedulerInterface()
    {
        return std::make_shared<SchedulerInterface>();
    }

    static LegacyInterfacePtr getLegacyInterface()
    {
        return std::make_shared<LegacyInterface>();
    }
};

} // namespace db
} // namespace yrpopper
