#include <db/legacy_interface.h>
#include <db/query/request_query.h>
#include <db/query/execute_query.h>

#include <db/handlers/imap_uidl_list.h>

#include <yplatform/find.h>

namespace yrpopper::db {

LegacyInterface::LegacyInterface()
{
    dispatcher = yplatform::find<query_dispatcher>("query_dispatcher");
}

future_imap_uidl_map LegacyInterface::loadImapUidls(PlatformContextPtr ctx, uint64_t folderId)
{
    using ImapUidlsRequestQuery = query::RequestQuery<imap_uidl_map_ptr, handlers::imap_uidl_list>;
    auto req = std::make_shared<ImapUidlsRequestQuery>(ctx, "imap_uidl_list");

    req->addArgs(folderId);
    return dispatcher->run(req, folderId, request_target::master);
}

future_void_t LegacyInterface::appendImapUidl(
    PlatformContextPtr ctx,
    uint64_t folderId,
    unsigned int uidl)
{
    auto req = std::make_shared<query::ExecuteQuery>(ctx, "append_imap_uidl");

    req->addArgs(folderId, uidl);
    return dispatcher->run(req, folderId, request_target::master);
}

} // namespace yrpopper::db
