#pragma once

#include <db/legacy_interface.h>

#include <db/imap_collector_interface.h>
#include <db/pop3_collector_interface.h>

#include <db/query_dispatcher/query_dispatcher.h>

#include <common/context.h>
#include <common/data_source.h>

#include <memory>

namespace yrpopper { namespace db {

class LegacyInterface
    : public ImapCollectorInterface
    , public Pop3CollectorInterface
{
public:
    LegacyInterface();

    future_imap_uidl_map loadImapUidls(PlatformContextPtr ctx, uint64_t folderId);
    future_void_t appendImapUidl(PlatformContextPtr ctx, uint64_t folderId, unsigned int uidl);

private:
    query_dispatcher_ptr dispatcher;
};

using LegacyInterfacePtr = std::shared_ptr<LegacyInterface>;

} // namespace db
} // namespace yrpopper
