#include <db/pop3_collector_interface.h>
#include <db/query/request_query.h>
#include <db/query/execute_query.h>

#include <db/handlers/uidl_list.h>

#include <yplatform/find.h>

namespace yrpopper::db {

Pop3CollectorInterface::Pop3CollectorInterface()
{
    dispatcher = yplatform::find<query_dispatcher>("query_dispatcher");
}

future_uidl_map Pop3CollectorInterface::loadUidls(PlatformContextPtr ctx, popid_t id)
{
    using Pop3UidlsRequestQuery = query::RequestQuery<uidl_map_ptr, handlers::uidl_list>;
    auto req = std::make_shared<Pop3UidlsRequestQuery>(ctx, "uidl_list");

    req->addArgs(id);
    return dispatcher->run(req, id, request_target::try_replica);
}

future_void_t Pop3CollectorInterface::appendUidl(
    PlatformContextPtr ctx,
    popid_t id,
    const std::string& uidl)
{
    auto req = std::make_shared<query::ExecuteQuery>(ctx, "append_uidl");

    req->addArgs(id, uidl);
    return dispatcher->run(req, id, request_target::master);
}

future_void_t Pop3CollectorInterface::saveUidls(
    PlatformContextPtr ctx,
    popid_t id,
    const new_uidl_map& uidlsMap)
{
    auto req = std::make_shared<query::ExecuteQuery>(ctx, "append_imap_uidl");

    std::vector<std::string> uidls;
    for (auto& uidl : uidlsMap)
    {
        uidls.push_back(uidl.first);
    }

    req->addArgs(id, std::move(uidls));
    return dispatcher->run(req, id, request_target::master);
}

} // namespace yrpopper::db
