#pragma once

#include <db/pop3_collector_interface.h>
#include <db/query_dispatcher/query_dispatcher.h>

#include <common/context.h>
#include <common/data_source.h>

#include <memory>

namespace yrpopper { namespace db {

class Pop3CollectorInterface
{
public:
    Pop3CollectorInterface();

    future_uidl_map loadUidls(PlatformContextPtr ctx, popid_t id);
    future_void_t appendUidl(PlatformContextPtr ctx, popid_t id, const std::string& uidl);
    future_void_t saveUidls(PlatformContextPtr ctx, popid_t id, const new_uidl_map& uidlsMap);

private:
    query_dispatcher_ptr dispatcher;
};

using Pop3CollectorInterfacePtr = std::shared_ptr<Pop3CollectorInterface>;

} // namespace db
} // namespace yrpopper
