#pragma once

#include <common/data_source.h>
#include <db/query/query.h>

#include <ymod_pq/call.h>

#include <yplatform/find.h>
#include <yplatform/future/future.hpp>

namespace yrpopper { namespace db { namespace query {

class ExecuteQuery : public Query
{
public:
    ExecuteQuery(const PlatformContextPtr& ctx, const std::string& query) : Query(ctx, query)
    {
    }

    future_void_t run_on_shard(const std::string& conninfo, ymod_pq::request_target target)
    {
        promise_void_t prom;

        auto pq = yplatform::find<ymod_pq::cluster_call>("pq_cluster_client");
        auto pqRes = pq->execute(
            ctx,
            conninfo,
            query,
            queryArgs,
            false,
            yplatform::time_traits::duration::max(),
            target);
        pqRes.add_callback(
            [pqRes, prom, this, self = shared_from_this()]() { handleRequest(pqRes, prom); });

        return prom;
    }

    void handleRequest(ymod_pq::future_result pqRes, promise_void_t prom)
    {
        try
        {
            if (!pqRes.get())
            {
                prom.set_exception(api::storage_error());
                return;
            }

            prom.set(VoidResult());
        }
        catch (...)
        {
            prom.set_current_exception();
        }
    }
};

} // namespace query
} // namespace db
} // namespace yrpopper
