#include <db/query/query.h>

#include <ymod_pq/bind_array.h>
#include <boost/lexical_cast.hpp>

namespace yrpopper::db::query {

void Query::addArg(const std::string& arg)
{
    ymod_pq::push_const_string(queryArgs, arg);
}

void Query::addArg(uint64_t arg)
{
    ymod_pq::push_const_string(queryArgs, boost::lexical_cast<std::string>(arg));
}

void Query::addArg(const boost::posix_time::ptime& arg)
{
    ymod_pq::push_const_date(queryArgs, arg);
}

void Query::addArg(std::vector<int64_t>&& arg)
{
    ymod_pq::push_swap_int64_vector(queryArgs, arg);
}

void Query::addArg(std::vector<std::string>&& arg)
{
    ymod_pq::push_swap_svector(queryArgs, arg);
}

} // namespace yrpopper::db::query
