#pragma once

#include <common/context.h>

#include <ymod_pq/bind_array.h>

#include <memory>
#include <utility>

namespace yrpopper { namespace db { namespace query {

class Query : public std::enable_shared_from_this<Query>
{
public:
    Query(const PlatformContextPtr& ctx, const std::string& query) : ctx(ctx), query(query)
    {
    }

    void addArg(const std::string& arg);
    void addArg(uint64_t arg);
    void addArg(const boost::posix_time::ptime& arg);
    void addArg(std::vector<int64_t>&& arg);
    void addArg(std::vector<std::string>&& arg);

    template <typename LastArg>
    void addArgs(LastArg&& arg)
    {
        addArg(std::forward<LastArg>(arg));
    }

    template <typename FirstArg, typename... TailArgs>
    void addArgs(FirstArg&& arg, TailArgs&&... tail)
    {
        addArg(std::forward<FirstArg>(arg));
        addArgs(std::forward<TailArgs>(tail)...);
    }

protected:
    PlatformContextPtr ctx;
    std::string query;
    ymod_pq::bind_array_ptr queryArgs = boost::make_shared<ymod_pq::bind_array>();
};

} // namespace query
} // namespace db
} // namespace yrpopper
