#pragma once

#include <db/query/query.h>
#include <api/error.h>

#include <ymod_pq/call.h>

#include <yplatform/find.h>
#include <yplatform/future/future.hpp>

namespace yrpopper { namespace db { namespace query {

template <typename ResultType, typename HandlerType>
class RequestQuery : public Query
{
    using HandlerTypePtr = boost::shared_ptr<HandlerType>;
    using ResPromise = yplatform::future::promise<ResultType>;
    using ResFuture = yplatform::future::future<ResultType>;

public:
    using ResType = ResultType;

    RequestQuery(const PlatformContextPtr& ctx, const std::string& query) : Query(ctx, query)
    {
    }

    ResFuture run_on_shard(const std::string& conninfo, ymod_pq::request_target target)
    {
        ResPromise prom;

        auto pqHandler = boost::make_shared<HandlerType>();

        auto pq = yplatform::find<ymod_pq::cluster_call>("pq_cluster_client");
        auto pqRes = pq->request(
            ctx,
            conninfo,
            query,
            queryArgs,
            pqHandler,
            false,
            yplatform::time_traits::duration::max(),
            target);
        pqRes.add_callback([pqRes, pqHandler, prom, this, self = shared_from_this()]() {
            handleRequest(pqRes, pqHandler, prom);
        });

        return prom;
    }

    void handleRequest(ymod_pq::future_result pqRes, HandlerTypePtr pqHandler, ResPromise prom)
    {
        try
        {
            if (!pqRes.get())
            {
                prom.set_exception(api::storage_error());
                return;
            }

            prom.set(pqHandler->result());
        }
        catch (...)
        {
            prom.set_current_exception();
        }
    }
};

} // namespace query
} // namespace db
} // namespace yrpopper
