#pragma once

#include <common/context.h>
#include <db/query_dispatcher/query_dispatcher.h>

#include <memory>
#include <string>

namespace yrpopper { namespace db {

class SchedulerInterface
{
public:
    SchedulerInterface();
    virtual ~SchedulerInterface() noexcept = default;

    future_void_t updateChunks(PlatformContextPtr ctx, const std::string& owner_name);
    future_chunk_requester_dict listChunks(PlatformContextPtr ctx, const std::string& owner_name);
    future_uint64_t getNewChunk(PlatformContextPtr ctx, const std::string& owner_name);
    future_void_t releaseChunk(
        PlatformContextPtr ctx,
        const std::string& owner_name,
        uint64_t chunkId);
    future_void_t updateTask(
        PlatformContextPtr ctx,
        const task_info& task,
        const std::string& server_response);
    future_task_ptr_list getTaskList(PlatformContextPtr ctx, const std::string& owner_name);

private:
    query_dispatcher_ptr dispatcher;
};

using SchedulerInterfacePtr = std::shared_ptr<SchedulerInterface>;

} // namespace db
} // namespace yrpopper
