#include <oauth/hack/util.h>
#include <oauth/hack/oauth_impl.h>
#include <common/util.h>

#include <boost/property_tree/ptree.hpp>
#include <boost/property_tree/xml_parser.hpp>

#include <algorithm>
#include <fstream>

using namespace std;

namespace yrpopper::oauth::hack {

void OauthServiceImpl::init(const yplatform::ptree& cfg)
{
    reload(cfg);
}

void OauthServiceImpl::reload(const yplatform::ptree& cfg)
{
    auto path = cfg.get<string>("access_tokens_file");
    cache.reload(path);
}

FutureRefreshTokenData OauthServiceImpl::getRefreshToken(
    yplatform::task_context_ptr /*ctx*/,
    const std::string& /*taskId*/)
{
    throw std::runtime_error("getRefreshToken forbidden for current installation");
}

FutureString OauthServiceImpl::getAccessToken(
    yplatform::task_context_ptr ctx,
    const std::string& server,
    const std::string& refreshToken)
{
    PromiseString token_promise;
    if (!supported_server(server))
    {
        token_promise.set_exception(std::runtime_error("forbidden server: " + server));
        return token_promise;
    }

    auto& email = refreshToken;
    try
    {
        auto token = cache.getAccessToken(email);
        token_promise.set(token);
    }
    catch(const std::exception& e)
    {
        YLOG_CTX_GLOBAL(ctx, info)
            << "failed to get access token for refresh_token: " << refreshToken
            << " reason: " << e.what();
        token_promise.set_exception(std::current_exception());
    }
    return token_promise;
}

} // namespace yrpopper::oauth

#include <yplatform/module_registration.h>

DEFINE_SERVICE_OBJECT(yrpopper::oauth::hack::OauthServiceImpl)
