#pragma once

#include <oauth/oauth.h>
#include <oauth/hack/token_cache.h>

namespace yrpopper { namespace oauth { namespace hack  {

struct Settings
{
    std::string access_tokens_file;
};

class OauthServiceImpl : public OauthService
{
public:
    OauthServiceImpl()
    {
    }
    virtual ~OauthServiceImpl(){};

    virtual void init(const yplatform::ptree& cfg);
    virtual void reload(const yplatform::ptree& cfg);

    virtual FutureRefreshTokenData getRefreshToken(
        yplatform::task_context_ptr ctx,
        const std::string& taskId) override;

    virtual FutureString getAccessToken(
        yplatform::task_context_ptr ctx,
        const std::string& server,
        const std::string& refreshToken) override;

    std::string getOauthApplication(const std::string& /*server*/) override
    {
        static const std::string OAUTH_APP_PLACEHOLDER = "oauth2-mail-migration";
        return OAUTH_APP_PLACEHOLDER;
    }

protected:
    TokenCache cache;
};

}}}
