#pragma once

#include <boost/algorithm/string.hpp>
#include <string>

namespace yrpopper::oauth::hack {

const std::string GMAIL_PASSWORD_PLACEHOLDER = "gmail-oauth2";
const std::string GMAIL_IMAP_SERVER = "imap.gmail.com";
const std::string OUTLOOK_PASSWORD_PLACEHOLDER = "outlook-oauth2";
const std::string OUTLOOK_IMAP_SERVER = "outlook.office365.com";

inline bool test_collector(const std::string& src_email, const std::string& dst_email)
{
    static const auto TEST_DST_EMAIL = "devops@test005.gan4test.ru";
    static const auto TEST_OUTLOOK_EMAIL = "devops@kontrtest.onmicrosoft.com";
    static const auto TEST_GMAIL_EMAIL = "devops@xn--90aru.com";

    auto test_gmail = src_email == TEST_GMAIL_EMAIL && dst_email == TEST_DST_EMAIL;
    auto test_outlook = src_email == TEST_OUTLOOK_EMAIL && dst_email == TEST_DST_EMAIL;
    return test_gmail || test_outlook;
}

inline bool validate_email(const std::string& src_email, const std::string& dst_email)
{
    return boost::algorithm::iequals(src_email, dst_email) || test_collector(src_email, dst_email);
}

inline bool supported_server(const std::string& server)
{
    return server == oauth::hack::GMAIL_IMAP_SERVER || server == oauth::hack::OUTLOOK_IMAP_SERVER;
}

inline bool is_gmail_hacked(const std::string& server, const std::string& password)
{
    return server == oauth::hack::GMAIL_IMAP_SERVER &&
        password == oauth::hack::GMAIL_PASSWORD_PLACEHOLDER;
}

inline bool is_outlook_hacked(const std::string& server, const std::string& password)
{
    return server == oauth::hack::OUTLOOK_IMAP_SERVER &&
        password == oauth::hack::OUTLOOK_PASSWORD_PLACEHOLDER;
}

inline bool is_collector_hacked(const std::string& server, const std::string& password)
{
    return is_gmail_hacked(server, password) || is_outlook_hacked(server, password);
}

}
