#pragma once

#include <yplatform/module.h>
#include <yplatform/task_context.h>
#include <yplatform/future/future.hpp>

namespace yrpopper { namespace oauth {

struct RefreshTokenData
{
    std::string refreshToken;
    std::string email;
    std::string provider;
};

typedef yplatform::future::future<RefreshTokenData> FutureRefreshTokenData;
typedef yplatform::future::promise<RefreshTokenData> PromiseRefreshTokenData;

typedef yplatform::future::future<std::string> FutureString;
typedef yplatform::future::promise<std::string> PromiseString;

class incorrect_data_exception : public std::runtime_error
{
public:
    incorrect_data_exception(const std::string& reason) : std::runtime_error(reason)
    {
    }
};

class OauthService : public yplatform::module
{
public:
    virtual ~OauthService(){};

    virtual FutureRefreshTokenData getRefreshToken(
        yplatform::task_context_ptr ctx,
        const std::string& taskId) = 0;

    virtual FutureString getAccessToken(
        yplatform::task_context_ptr ctx,
        const std::string& server,
        const std::string& refreshToken) = 0;

    virtual std::string getOauthApplication(const std::string& server) = 0;
};

} // namespace oauth
} // namespace yrpopper
