#pragma once

#include <oauth/oauth.h>
#include <oauth/oauth_settings.h>
#include <oauth/token_loader.h>

namespace yrpopper { namespace oauth {

class OauthServiceImpl : public OauthService
{
public:
    OauthServiceImpl()
    {
    }
    virtual ~OauthServiceImpl(){};

    virtual void init(const yplatform::ptree& xml);
    virtual void reload(const yplatform::ptree& xml);

    virtual FutureRefreshTokenData getRefreshToken(
        yplatform::task_context_ptr ctx,
        const std::string& taskId) override;

    virtual FutureString getAccessToken(
        yplatform::task_context_ptr ctx,
        const std::string& server,
        const std::string& refreshToken) override;

    std::string getOauthApplication(const std::string& server) override
    {
        auto srv = settings.servers.find(server);
        if (srv == settings.servers.end())
        {
            return "";
        }
        return srv->second;
    }

protected:
    void readSettings(const yplatform::ptree& cfg);

    Settings settings;
};

}}
