#pragma once

#include <common/util.h>
#include <common/context.h>
#include <common/data_source.h>
#include <processor/settings.h>
#include <processor/processor.h>

#include <db/interface_provider.h>
#include <db/legacy_interface.h>

namespace yrpopper { namespace processor {

struct rpop_args_t
{
    rpop_args_t(const rpop_context_ptr& context_)
        : context(context_)
        , process_status(new task_status)
        , task_error(code::ok)
        , is_uidl_hash_disabled(false)
    {
        process_status->start_time = time(0);
        process_status->bad_retries = context->task->bad_retries;
    }

    promise_task_status_ptr prom;
    rpop_context_ptr context;
    task_status_ptr process_status;
    error task_error;
    bool is_uidl_hash_disabled;

    db::LegacyInterfacePtr dbInterface;
};

typedef boost::shared_ptr<rpop_args_t> rpop_args_ptr;

} // namespace processor
} // namespace yrpopper
