#pragma once

#include <expat.h>
#include <common/context.h>
#include <common/uidl.h>
#include <ymod_httpclient/response_handler.h>

namespace yrpopper { namespace processor { namespace handlers {

class abook_sync : public ymod_http_client::response_handler
{
public:
    abook_sync(rpop_context_ptr ctx);
    virtual ~abook_sync()
    {
        XML_ParserFree(parser_);
    }

    ymod_http_client::handler_version version() const;
    void set_code(int code, const std::string& description);
    void handle_data(const char* data, unsigned long long size);

    void handle_data_end();

    void on_start_element(void* user_data, const XML_Char* name, const XML_Char** atts);
    void on_end_element(void* user_data, const XML_Char* name);
    void on_characters(void* user_data, const XML_Char* s, int len);

    bool confirm() const
    {
        return confirm_tag_;
    }

    int rec_count() const
    {
        return rec_count_;
    }

private:
    bool confirm_tag_;
    bool in_error_tag_;
    int rec_count_;
    string error_info_;
    bool m_status_error, m_error;
    std::string m_buffer;
    rpop_context_ptr ctx_;
    XML_Parser parser_;
};

typedef boost::shared_ptr<abook_sync> abook_sync_ptr;

} // namespace handlers
} // namespace processor
} // namespace yrpopper
