#pragma once

#include <expat.h>
#include <yplatform/util.h>
#include <common/context.h>
#include <common/uidl.h>
#include <ymod_httpclient/response_handler.h>

namespace yrpopper { namespace processor { namespace handlers {

class validate : public ymod_http_client::response_handler
{
public:
    validate(rpop_context_ptr ctx);
    virtual ~validate()
    {
        XML_ParserFree(parser_);
    }

    void handle_data(const char* data, unsigned long long size);

    void handle_data_end();

    void on_start_element(void* user_data, const XML_Char* name, const XML_Char** atts);
    void on_end_element(void* user_data, const XML_Char* name);
    void on_characters(void* user_data, const XML_Char* s, int len);

    bool confirm() const
    {
        return confirm_tag_;
    }

    bool is_email_invalid() const
    {
        return yplatform::util::istarts_with(error_description_, "Bad e-mail format: ");
    }

private:
    bool confirm_tag_;
    bool in_error_tag_;
    string error_info_;
    string error_description_;
    rpop_context_ptr ctx_;
    XML_Parser parser_;
};

typedef boost::shared_ptr<validate> validate_ptr;

} // namespace handlers
} // namespace processor
} // namespace yrpopper
