#pragma once

#include <yplatform/active/object.h>
#include <common/context.h>
#include <common/config.h>
#include <common/data_source.h>
#include <boost/lexical_cast.hpp>
#include <string>
#include <vector>

namespace yrpopper { namespace processor {

typedef yplatform::future::promise<task_status_ptr> promise_task_status_ptr;
typedef yplatform::future::future<task_status_ptr> future_task_status_ptr;

namespace bpt = boost::posix_time;

class processor : public yplatform::active::object
{
public:
    processor() : yplatform::active::object()
    {
    }

    virtual ~processor()
    {
    }

    virtual future_task_status_ptr process(
        rpop_context_ptr context,
        const yplatform::active::ptime& deadline = bpt::max_date_time) = 0;
};

} // namespace processor
} // namespace yrpopper
