#pragma once

#include <common/context.h>
#include <common/host_info.h>
#include <ymod_httpclient/call.h>
#include <list>

namespace yrpopper { namespace processor {

struct settings
{
    struct folder_names
    {
        std::string drafts;
        std::string sent;
        std::string trash;
        std::string spam;
    };

    struct email_template
    {
        std::map<string, string> localizations;

        bool empty() const
        {
            return localizations.empty();
        }

        const string& get_email(const string l, const string& def_l) const
        {
            static const string EMPTY_EMAIL = "";
            std::map<string, string>::const_iterator i_email = localizations.find(l);
            if (i_email != localizations.end()) return i_email->second;
            i_email = localizations.find(def_l);
            if (i_email != localizations.end()) return i_email->second;
            return EMPTY_EMAIL;
        }
    };

    settings()
        : enable_validator(false)
        , enable_abook_sync(false)
        , abook_sync_start_date(0)
        , abook_retries_limit(7 * 24)
        , save_retries(3)
        , max_sent_count(300)
        , max_sent_size(400 * 1024 * 1024)
        , max_mail_size(41 * 1024 * 1024)
        , enable_yandex_optimization(false)
        , blackbox_cache_invalidate(4 * 60 * 60)
    {
        my_ip_addr = get_my_ipaddr();
    }

    std::list<string> validator_hosts;
    string validator_request;
    bool enable_validator;
    std::pair<unsigned, boost::posix_time::time_duration> validator_brake;

    string abook_sync_request;
    string abook_sync_request_body;
    std::list<string> abook_sync_hosts;
    bool enable_abook_sync;
    std::pair<unsigned, boost::posix_time::time_duration> abook_sync_brake;
    std::time_t abook_sync_start_date;
    unsigned abook_retries_limit;

    string save_path;
    string sent_folder_name;
    unsigned save_retries;
    std::size_t max_sent_count;
    std::size_t max_sent_size;
    std::size_t max_mail_size;
    email_template big_mail_notify;
    string default_language;
    string bb_login_service;
    bool enable_yandex_optimization;
    std::set<string> remove_headers;

    string my_ip_addr;
    std::time_t blackbox_cache_invalidate;

    typedef std::pair<std::string, bool> oauthInfo;
    std::vector<oauthInfo> oauth2Workaround;

    typedef std::list<std::pair<std::string, std::pair<bool, folder_names>>>
        mapped_folder_names_t; // server -> (keep_orig_names, [names])
    mapped_folder_names_t mapped_folder_names;
};

typedef boost::shared_ptr<settings> settings_ptr;

}}
