#pragma once

#include <processor/settings.h>
#include <processor/sent_counter.h>
#include <processor/triggers/trigger.h>
#include <processor/handlers/abook_sync.h>

namespace yrpopper { namespace processor { namespace triggers {

class abook : public trigger
{
public:
    abook() : brake_counter_("trigger_abook")
    {
    }
    void init(const settings_ptr& st);
    void reload(const settings_ptr& st)
    {
        brake_counter_.max_count(st->abook_sync_brake.first);
        brake_counter_.dimension_interval(st->abook_sync_brake.second);
    }
    future_void_t operator()(const rpop_args_ptr& args);

private:
    bool is_abook_enable(const rpop_args_ptr& args);
    void handle_abook_sync(
        rpop_args_ptr args,
        handlers::abook_sync_ptr handler,
        yplatform::future::future<void> res,
        promise_void_t prom);

    ymod_http_client::remote_point_info_ptr get_host()
    {
        if (abook_sync_hosts.empty()) return ymod_http_client::remote_point_info_ptr();

        return abook_sync_hosts[random() % abook_sync_hosts.size()];
    }
    settings_ptr st_;
    sent_counter brake_counter_;
    std::vector<ymod_http_client::remote_point_info_ptr> abook_sync_hosts;
};

} // namespace triggers
} // namespace processor
} // namespace yrpopper
