#include <processor/triggers/email_validator.h>
#include <yplatform/encoding/url_encode.h>
#include <yplatform/find.h>
#include <boost/format.hpp>

namespace yrpopper::processor::triggers {

void email_validator::init(const settings_ptr& st)
{
    st_ = st;
    validators.reserve(st->validator_hosts.size());
    for (const string& url : st->validator_hosts)
    {
        validators.push_back(yplatform::find<yhttp::call>("http_client")->make_rm_info(url));
    }
    reload(st_);
}

future_void_t email_validator::operator()(const rpop_args_ptr& args)
{
    promise_void_t prom;
    if (args->context->task->validated || !st_->enable_validator ||
        args->context->task->email.empty() || !++brake_counter_)
    {
        prom.set(VoidResult());
        return prom;
    }
    handlers::validate_ptr get_handler(new handlers::validate(args->context));

    std::ostringstream os;
    os << boost::format(st_->validator_request) %
            yplatform::url_encode(args->context->task->bb_info.getUid()) %
            yplatform::url_encode(args->context->task->email);

    yplatform::future::future<void> fres =
        yplatform::find<yhttp::call>("http_client")
            ->get_url(args->context, get_handler, get_host(), os.str());

    fres.add_callback(
        boost::bind(&email_validator::handle_validate, this, args, get_handler, fres, prom));
    return prom;
}

void email_validator::handle_validate(
    rpop_args_ptr args,
    handlers::validate_ptr handler,
    yplatform::future::future<void> res,
    promise_void_t prom)
{
    if (res.has_exception())
    {
        YRIMAP_ERROR(args->context)
            << "validate: status=error (" << get_exception_reason(res) << ")";
        // if (handler->is_email_invalid ()) args->process_status->validated = 2;
    }
    else if (handler->confirm())
    {
        YRIMAP_LOG(args->context) << "validate: status=ok (popid=" << args->context->task->popid
                                  << ", email=" << args->context->task->email << ")";
        args->process_status->validated = 1;
    }
    else
    {
        YRIMAP_ERROR(args->context)
            << "validate: status=error (confirm tag not found in validator response)";
    }
    prom.set(VoidResult());
}

} // namespace yrpopper::processor::triggers
