#pragma once

#include <processor/settings.h>
#include <processor/sent_counter.h>
#include <processor/triggers/trigger.h>
#include <processor/handlers/validate.h>

namespace yrpopper { namespace processor { namespace triggers {

class email_validator : public trigger
{
public:
    email_validator() : brake_counter_("trigger_validator")
    {
    }
    void init(const settings_ptr& st);
    void reload(const settings_ptr& st)
    {
        brake_counter_.max_count(st->validator_brake.first);
        brake_counter_.dimension_interval(st->validator_brake.second);
    }

    future_void_t operator()(const rpop_args_ptr& args);

private:
    void handle_validate(
        rpop_args_ptr args,
        handlers::validate_ptr handler,
        yplatform::future::future<void> res,
        promise_void_t prom);

    ymod_http_client::remote_point_info_ptr get_host()
    {
        if (validators.empty()) return ymod_http_client::remote_point_info_ptr();

        return validators[random() % validators.size()];
    }
    settings_ptr st_;
    sent_counter brake_counter_;
    std::vector<ymod_http_client::remote_point_info_ptr> validators;
};

} // namespace triggers
} // namespace processor
} // namespace yrpopper
