#pragma once

#include <vector>
#include <processor/triggers/trigger.h>

namespace yrpopper { namespace processor { namespace triggers {

class multiplexor : public trigger
{
    typedef boost::mutex mutex_t;
    typedef boost::unique_lock<mutex_t> lock_t;

    struct task_status
    {
        task_status(std::size_t count) : active(count)
        {
        }

        std::size_t active;
        promise_void_t prom;
        mutex_t mux;
    };
    typedef boost::shared_ptr<task_status> task_status_ptr;

public:
    void add_trigger(const trigger_ptr& tr)
    {
        triggers_.push_back(tr);
    }

    void init(const settings_ptr& st)
    {
        for (std::size_t i = 0; i < triggers_.size(); ++i)
            triggers_[i]->init(st);
    }
    void reload(const settings_ptr& st)
    {
        for (std::size_t i = 0; i < triggers_.size(); ++i)
            triggers_[i]->reload(st);
    }

    virtual future_void_t operator()(const rpop_args_ptr& args)
    {
        if (triggers_.empty())
        {
            promise_void_t prom;
            prom.set(VoidResult());
            return prom;
        }
        task_status_ptr status(new task_status(triggers_.size()));
        for (std::size_t i = 0; i < triggers_.size(); ++i)
        {
            future_void_t fres = (*triggers_[i])(args);
            fres.add_callback(boost::bind(&multiplexor::handle_trigger, this, status, fres));
        }
        return status->prom;
    }

private:
    void handle_trigger(const task_status_ptr& status, future_void_t /* fres */)
    {
        lock_t lock(status->mux);
        if (--status->active) return;
        status->prom.set(VoidResult());
    }

    std::vector<trigger_ptr> triggers_;
};

} // namespace triggers
} // namespace processor
} // namespace yrpopper
