#pragma once

#include <processor/args.h>
#include <yplatform/future/future.hpp>

namespace yrpopper { namespace processor { namespace triggers {

typedef yplatform::future::future<VoidResult> future_void_t;
typedef yplatform::future::promise<VoidResult> promise_void_t;

class trigger
{
public:
    virtual ~trigger() noexcept = default;
    virtual void init(const settings_ptr& st) = 0;
    virtual void reload(const settings_ptr& st) = 0;
    virtual future_void_t operator()(const rpop_args_ptr& args) = 0;
};

typedef boost::shared_ptr<trigger> trigger_ptr;

} // namespace triggers
} // namespace processor
} // namespace yrpopper
