#include "processor_header_generator.h"
#include <processor/rfc822date.h>

#include <butil/butil.h>

namespace yrpopper::processor {

void ProcessorHeaderGenerator::generateBaseHeaders()
{
    auto task = context->task;
    std::string short_name = task->login.substr(0, task->login.find("@"));
    std::string received_date;
    {
        char timestr[256];
        char zonestr[256];
        time_t rawtime;
        time(&rawtime);
        received_date = rfc822date(&rawtime, timestr, sizeof timestr, zonestr, sizeof zonestr);
    }
    stream << "X-yandex-pop-server: " << task->server << crlf << "X-yandex-rpop-id: " << task->popid
           << crlf << "X-yandex-rpop-info: " << short_name << "@" << task->server << crlf
           << "X-Yandex-Suid: " << task->suid << " " << task->bb_info.getEmail() << crlf;

    if (!message->srcFolder.empty())
    {
        stream << "X-yandex-rpop-foldername: " << encode_base64(message->srcFolder) << crlf;
    }

    stream << "Received: "
           << "from " << short_name << "@" << task->server << " ([" << context->host_ip << "])"
           << crlf << "\tby mail.yandex.ru with POP3 id " << context->uniq_id() << crlf << "\tfor "
           << task->suid << "@" << task->popid << "; " << received_date << crlf;
}

void ProcessorHeaderGenerator::generateXYandexHint(MessageInfoPtr messageInfo)
{
    std::stringstream ss;

    size_t flags = 0;
    if (message->answered)
    {
        flags |= FLAG_ANSWERED;
    }
    if (message->deleted)
    {
        flags |= FLAG_DELETED;
    }
    if (message->seen)
    {
        ss << "notify=0\n";
        flags |= FLAG_SEEN;
    }
    else
    {
        ss << "notify=1\n";
    }

    if (flags != 0)
    {
        ss << "mixed=" << flags << "\n";
    }

    if (message->flagged)
    {
        ss << "label=priority_high\n";
    }

    time_t recievedDate =
        messageInfo->minReceivedDate ? messageInfo->minReceivedDate : messageInfo->dateHeader;
    if (recievedDate != 0) ss << "received_date=" << recievedDate << "\n";

    for (auto& label : message->labels)
    {
        ss << "userlabel=" << label << "\n";
    }

    for (auto& lid : message->lids)
    {
        ss << "lid=" << lid << "\n";
    }

    ss << "folder_path=" << message->dstFolder << "\n";
    ss << "folder_path_delim=" << message->dstDelim << "\n";

    if (!message->spamFolder.empty())
    {
        ss << "folder_spam_path=" << message->spamFolder << "\n";
    }

    bool ignoreLoop =
        messageInfo->isLoop && (messageInfo->maxReceivedDate < context->task->create_date);
    if (ignoreLoop) ss << "skip_loop_prevention=1\n";

    ss << "forward=1\n";
    string hintValue = encode_base64(ss.str());

    stream << "X-Yandex-Hint: " << hintValue << crlf;
}

} // namespace yrpopper::processor
